package gov.va.genisis2.common.enums;

public enum UserStatusEnum {

	ACTIVE(1, "Active"), DISABLE(0, "Disable");

	private int id;
	private String desc;

	/**
	 * @param id
	 * @param desc
	 */
	private UserStatusEnum(int id, String desc) {
		this.id = id;
		this.desc = desc;
	}

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @return the desc
	 */
	public String getDesc() {
		return desc;
	}

	public static String getStatus(int statusId) {
		String status = null;

		for (UserStatusEnum userStatus : UserStatusEnum.values()) {
			if (userStatus.id == statusId) {
				status = userStatus.desc;
				break;
			}
		}

		return status;
	}
}